/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* -----------------------------------------------------------------------
 * File: target.h
 * Author: Joerg Striegel 4.6.96
 * Purpose: This file contains the function prototypes for setting up the
 * target decoders and for setting all target attribute page properties
 * and activate a target page
 * ----------------------------------------------------------------------- */

#ifndef TARGET_H_INCLUDED
#define TARGET_H_INCLUDED

#include <tardefs.h>

#ifdef __cplusplus
extern "C" {
#endif
  
/* ------------------------------------------------------------------------
 * Target Behaviout Programming Functions
 * ------------------------------------------------------------------------ */

CLI  b_errtype EXPORT BestTargetAttrPageInit(                      /* @tapginit */
					     b_handletype handle,
					     b_int32      page_num         /* @page */
					     );


CLI  b_errtype EXPORT BestTargetAttrPtrSet(                        /* @taptrset */
					   b_handletype handle,
					   b_int32      page_num,          /* @page */
					   b_int32      offset             /* @offs */
					   );


CLI  b_errtype EXPORT BestTargetAttrPropSet(                       /* @taprpset */
					    b_handletype    handle,
					    b_tattrproptype tattrprop,     /* @prop */
					    b_int32         value          /* @val */
					    );


CLI  b_errtype EXPORT BestTargetAllAttr1xProg(		     /* @taa1xprog */
					      b_handletype handle,
					      b_int32 doloop,		     /* @loop */
					      b_int32 waits,		     /* @w */
					      b_int32 term,		     /* @term */
					      b_int32 dperr,		     /* @dperr */
					      b_int32 dserr,		     /* @dserr */
					      b_int32 aperr,		     /* @aperr */
					      b_int32 wrpar		     /* @wp */
					      );


CLI  b_errtype EXPORT BestTargetAttrPropGet(                       /* @taprpget */
					    b_handletype    handle,
					    b_tattrproptype tattrprop,     /* @prop */
					    b_int32         *value         /* #RETURN "attribute value: %08lx\\h\n" */
					    );


CLI  b_errtype EXPORT BestTargetAttrPropDefaultSet(                /* @taprpdefset */
						   b_handletype handle
						   );


CLI  b_errtype EXPORT BestTargetAttrPhaseRead(                     /* @taphread */
					      b_handletype handle
					      );


CLI  b_errtype EXPORT BestTargetAttrPhaseProg(                     /* @taphprog */
					      b_handletype handle
					      );


/* programms a phase in the attribute memory */
CLI b_errtype EXPORT BestTargetAttrLineProg(                      /* @talprog */
                  b_handletype handle,
                  b_int32 page_num,                                    /* @page */
                  b_int32 offset                                       /* @offs */
                  );

/* programming properties of one group only */
CLI b_errtype EXPORT BestTargetAttrGroupLineProg(                /* @tagrplprog */
                  b_handletype handle,
                  b_tattrgrouptype group,                              /* @grp  */
                  b_int32 page_num,                                    /* @page */
                  b_int32 offset                                       /* @offs */
                  );
                  
/* read the attributes from the attribute memory */
CLI b_errtype EXPORT BestTargetAttrLineRead(                      /* @talread */
                  b_handletype handle,           
                  b_int32 page_num,                                    /* @page */
                  b_int32 offset                                       /* @offs */
                  );
                  
/* programming properties of one group only */
CLI b_errtype EXPORT BestTargetAttrGroupLineRead(                /* @tagrplread */
                  b_handletype handle,
                  b_tattrgrouptype group,                              /* @grp  */
                  b_int32 page_num,                                    /* @page */
                  b_int32 offset                                       /* @offs */
                  );


/* ------------------------------------------------------------------------
 * Exerciser Run Functions
 * ------------------------------------------------------------------------ */

CLI  b_errtype EXPORT BestTargetAttrPageSelect(                      /* @tapgsel */
					   b_handletype handle,
					   b_int32      page_num     /* @page */
					   );




/* ------------------------------------------------------------------------
 * Target Generic Propertie functions 
 * ------------------------------------------------------------------------ */

CLI b_errtype EXPORT BestTargetGenPropSet(                         /* @tgprpset */
					  b_handletype        handle,     
					  b_targetgenproptype targetgenprop,        /* @prop */
					  b_int32             value                 /* @val */
					  );


CLI b_errtype EXPORT BestTargetGenPropGet(                         /* @tgprpget */
					  b_handletype        handle,
					  b_targetgenproptype targetgenprop, /* @prop */
					  b_int32             *value         /* #RETURN "value: %08lx\\h\n" */
					  );


CLI b_errtype EXPORT BestTargetGenPropDefaultSet(                 /* @tgprpdefset */
						 b_handletype        handle
						 );

/* -----------------------------------------------------------------
 * Expasion Rom Programming Functions 
 * ----------------------------------------------------------------- */

CLI b_errtype EXPORT BestExpRomByteWrite(                           /* @erbytewrite */
					 b_handletype handle,
					 b_int32      offset,       /* @offs */
					 b_int32      value         /* @val  */
					 );


CLI b_errtype EXPORT BestExpRomByteRead(                            /* @erbyteread */
					b_handletype handle,
					b_int32      offset,        /* @offs */
					b_int32      *value         /* #RETURN "value=: %02lx\\h\n" */
					);



#ifdef __cplusplus
}
#endif

#endif




